﻿/* mtwimg.js

Shelley Powers
http://burningbird.net/technology

Aby wykorzystać tę bibliotekę, należy dodać znacznik script z atrybutem scr, w którym poda się ścieżkę dostępu do tego pliku.
Poza tym należy dołączyć w kodzie HTML plik img.css albo wprowadzić jego ustawnienia do wykorzystywanego juz arkusza stylów.


Biblioteka ta jest udostępniana na zasadach licencji GPL, GNU General Public License. Szczegóły na  http://burningbird.net/technology/
*/

// Zmienne globalne, można je zmieniać
// Obraz 'roboczy'
var workingImage = "http://burningbird.net/wp/ajax-loader.gif";

// W tym miejscu zaprzestan edycji, chyba że chcesz zmienić podstawowe zasady działania kodu


// Nieagresywne wczytywanie
// Powinno sprawdzać się z innymi aplikacjami
function addLoadEvent(func) { 
  var oldonload = window.onload; 
  if (typeof window.onload != 'function') { 
    window.onload = func; 
  } else { 
    window.onload = function() { 
      oldonload(); 
      func(); 
    } 
  } 
} 
 
// Obsługa zdarzeń dla wczytywania
// gdy aplikacja korzysta z wielu bibliotek JS
function addLoad(func) {
   if (window.addEventListener) {
      window.addEventListener("load",func,false);
   } else if (window.attachEvent) {
      window.attachEvent("onload",func);
   } else {
     addLoadEvent(func);
   }
}

addLoad(setUp);

// Obsługa przezroczystości we wszystkich przeglądarkach
function setOpacity(obj,val) {
  obj.style.opacity = val;
  obj.style.MozOpacity=val;
  obj.style.KhtmlOpacity=val;
  val*=100;
  obj.style.filter = "alpha(opacity="+val+")";
} 

//
// Pobiera parametr wcisniętego klawisza. Wciśnięcie 'x' zamyka duzy obraz.
//
function getKey(evnt){
   evnt = (evnt) ? evnt : ((window.event) ? window.event : "");
   var keycode = (evnt.which) ? evnt.which : evnt.keyCode;
   var key = String.fromCharCode(keycode).toLowerCase();
   if(key == 'x'){ restore(); }
}


// Sprawdza, czy nie został wciśnięty klawisz
//
function listenKey () {	

   if (document.addEventListener) {
      document.addEventListener("keypress",getKey,false);
   } else if (document.attachEvent) {
      document.attachEvent("onkeypress",getKey);
   } else {
      document.onkeypress = getKey; 
   }
}
	
// Przestaje sprawdzać, czy nie został wciśnięty klawisz
//
function stopListenKey() {
   if (document.removeEventListener) {
      document.removeEventListener("keypress",getKey,false);
   } else if (document.detachEvent) {
      document.detachEvent("onkeypress",getKey);
   } else {
      document.onkeypress = ''; 
   }
}

// img.js setUp
// Dodaje 'opakowanie' zawartości strony
// Odnajduje wszystkie obrazy opatrzone klasą "thumb"
// Dodaje każdemu z nich obsługę zdarzenia
// Dodaje obsługę zdarzenia do każdego zdjęcia w pełnej rozdzielczości
//   Jest częścią procesu wyświetlania strony

function setUp() {

   var elem = elementClass = null;
   var elems = document.getElementsByTagName('img');
   for (i = 0; i < elems.length; i++) {
      elem = elems[i];
      elementClass = elem.getAttribute("class");
      elementClass = elementClass ? elementClass : elem.getAttribute("className");
      if (elementClass == 'thumb') {
         elem.onclick=expandPic;
      }
   }

}

// Rozwija zdjęcie
//   Dodaje obsługę zdarzenia naciśnięcia klawisza
//   Ustawia nieprzezroczystość 'opakowania' strony, aby ukryć jej zawartość
//   Określa położenie klikniętej miniatury
//   Ustawia położenie ramki dużego zdjęcia
//   Ustawia nowe zdjęcie
function expandPic(evnt) {
 
   listenKey();
 
   evnt = (evnt) ? evnt : ((window.event) ? window.event : "");
   // Odnajduje położenie zdjęcia
   var pos = 0;
   if (window.pageYOffset) {
      pos = window.pageYOffset;
   } else if (document.documentElement && document.documentElement.scrollTop) {
      pos = document.documentElement.scrollTop
   } else if (document.body) {
      pos = document.body.scrollTop;
   }

   var evntTarget = (evnt.target) ? evnt.target : evnt.srcElement;

   // Pobiera nazwę obrazu źródlowego
   var oParent = evntTarget.parentNode;

   var imgs = document.getElementsByTagName('img');
   imgs['mtwPictureimage'].src=oParent.href;

   // Wyszarza tło,  wyświetla powiększone zdjęcie
   var obj = document.getElementById('mtwPicture');
   obj.style.top = pos + "px";
   var cover = document.getElementById('mtwCover');
   setOpacity(cover,.1);
   obj.style.visibility='visible';

   // Dodaje obsługę zdarzenia zdjęcia
   obj.onclick=restore;

   imgs['mtwPictureimage'].className = "mtwPictureimage2";

   // koniec zdarzenia
   return false;
}


// Odzyskuje
// Przestaje sprawdzać, czy został wciśnięty klawisz
// Ustawia pełną przezroczystoć 'opakowania' strony
// Resetuje obraz ramki na obraz 'roboczy'
// Ukrywa ramkę
function restore() {

   stopListenKey();

   var imgs = document.getElementsByTagName('img');
   imgs['mtwPictureimage'].src=workingImage;
   imgs['mtwPictureimage'].className = "mtwPictureimage1";

   // przywraca ustawienia nieprzezroczystości
   var cover = document.getElementById('mtwCover');
   setOpacity(cover,1.0);
   cover.style.backgroundColor="transparent";
   var obj = document.getElementById('mtwPicture');

   // Odkrywa obraz i czysci znacznik img
   obj.style.visibility='hidden';

}
